//
//	MBsysTran - Release 8.1
//
//	Copyright 
//	Universite catholique de Louvain (UCLouvain) 
//	Mechatronic, Electrical Energy, and Dynamic systems (MEED Division) 
//	2, Place du Levant
//	1348 Louvain-la-Neuve 
//	Belgium 
//
//	http://www.robotran.be 
//
//	==> Generation Date: Wed Oct  2 17:09:36 2024
//	==> using automatic loading with extension .mbs 
//
//	==> Project name: pendulum_spring_c
//
//	==> Number of joints: 4
//
//	==> Function: F1 - Recursive Direct Dynamics of tree-like MBS
//
//	==> Git hash: 0cc862d03ff17d3428bf53a85358bd520952fe65
//
//	==> Input XML
//

#include <math.h> 

#include "mbs_data.h"

void mbs_dirdyna(double **M, double *c,
MbsData *s, double tsim)
{
#include "mbs_dirdyna_pendulum_spring_c.h"

double *q, *qd;
double *g, *m;
double **l, **In, **dpt, **frc, **trq;

q = s->q;
qd = s->qd;

dpt = s->dpt;
l  = s->l;

m = s->m;
In = s->In;

frc = s->frc;
trq = s->trq;
g = s->g;
 
// Trigonometric functions

S1 = sin(q[1]);
C1 = cos(q[1]);
S3 = sin(q[3]);
C3 = cos(q[3]);
S4 = sin(q[4]);
C4 = cos(q[4]);
 
// Augmented Joint Position Vectors

Dz23 = q[2]+dpt[3][3];
 
// Forward Kinematics

BS91 = -qd[1]*qd[1];
AF11 = g[3]*S1;
AF31 = -g[3]*C1;
AF12 = AF11+(2.0)*qd[1]*qd[2];
AF32 = AF31+BS91*Dz23;
BS93 = -qd[3]*qd[3];
AF13 = g[3]*S3;
AF33 = -g[3]*C3;
OM24 = qd[3]+qd[4];
BS94 = -OM24*OM24;
AF14 = AF13*C4-S4*(AF33+BS93*dpt[3][6]);
AF34 = AF13*S4+C4*(AF33+BS93*dpt[3][6]);
AM14_3 = dpt[3][6]*C4;
AM34_3 = dpt[3][6]*S4;
 
// Backward Dynamics

FA14 = -frc[1][4]+m[4]*AF14;
FA34 = -frc[3][4]+m[4]*(AF34+BS94*l[3][4]);
CF24 = -trq[2][4]+FA14*l[3][4];
FB14_3 = m[4]*(AM14_3+l[3][4]);
FB34_3 = m[4]*AM34_3;
CM24_3 = In[5][4]+FB14_3*l[3][4];
FB14_4 = m[4]*l[3][4];
CM24_4 = In[5][4]+FB14_4*l[3][4];
FA13 = -frc[1][3]+m[3]*AF13;
CF23 = -trq[2][3]+CF24+FA13*l[3][3]+dpt[3][6]*(FA14*C4+FA34*S4);
FB13_3 = m[3]*l[3][3];
CM23_3 = In[5][3]+CM24_3+FB13_3*l[3][3]+dpt[3][6]*(FB14_3*C4+FB34_3*S4);
FA12 = -frc[1][2]+m[2]*AF12;
FA32 = -frc[3][2]+m[2]*AF32;
FB12_1 = m[2]*Dz23;
FA11 = -frc[1][1]+m[1]*AF11;
CF21 = -trq[2][1]-trq[2][2]+FA11*l[3][1]+FA12*Dz23;
FB11_1 = m[1]*l[3][1];
CM21_1 = In[5][1]+FB11_1*l[3][1]+FB12_1*Dz23;
 
// Symbolic model output

c[1] = CF21;
c[2] = FA32;
c[3] = CF23;
c[4] = CF24;
M[1][1] = CM21_1;
M[2][2] = m[2];
M[3][3] = CM23_3;
M[3][4] = CM24_3;
M[4][3] = CM24_3;
M[4][4] = CM24_4;

// Number of continuation lines = 0

}
